/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.Decoder;
import net.sourceforge.peers.media.PcmaDecoder;
import net.sourceforge.peers.media.PcmuDecoder;
import net.sourceforge.peers.rtp.RtpListener;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;

public class IncomingRtpReader
implements RtpListener {
    private RtpSession rtpSession;
    private AbstractSoundManager soundManager;
    private Decoder decoder;
    private String peersHome;
    private String mediaDir;
    private String destFileName;
    private AudioFormat audioFormat;
    private Logger logger;

    public IncomingRtpReader(RtpSession rtpSession, AbstractSoundManager soundManager, Codec codec, Logger logger, String peersHome, String mediaDir) throws IOException {
        logger.debug("playback codec:" + codec.toString().trim());
        this.rtpSession = rtpSession;
        this.soundManager = soundManager;
        switch (codec.getPayloadType()) {
            case 0: {
                this.decoder = new PcmuDecoder();
                break;
            }
            case 8: {
                this.decoder = new PcmaDecoder();
                break;
            }
            default: {
                throw new RuntimeException("unsupported payload type");
            }
        }
        rtpSession.addRtpListener(this);
        this.peersHome = peersHome;
        this.mediaDir = mediaDir;
        this.audioFormat = new AudioFormat(8000.0f, 8, 1, false, false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String date = simpleDateFormat.format(new Date());
        StringBuilder buf = new StringBuilder();
        buf.append(peersHome).append(File.separator);
        buf.append(mediaDir).append(File.separator);
        buf.append(date).append("_");
        buf.append(this.audioFormat.getEncoding()).append("_");
        buf.append(this.audioFormat.getSampleRate()).append("_");
        buf.append(this.audioFormat.getSampleSizeInBits()).append("_");
        buf.append(this.audioFormat.getChannels()).append("_");
        buf.append(this.audioFormat.isBigEndian() ? "be" : "le");
        this.destFileName = buf.toString() + "_rec_bonrix";
        File f = new File(this.destFileName);
        f.createNewFile();
    }

    public void start() {
        this.rtpSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedRtpPacket(RtpPacket rtpPacket) {
        byte[] rawBuf = this.decoder.process(rtpPacket.getData());
        if (this.soundManager != null) {
            this.soundManager.writeData(rawBuf, 0, rawBuf.length);
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.destFileName, true);
            output.write(rawBuf);
        }
        catch (Exception ex) {
            this.logger.error("error creating file - bonrix", ex);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                this.logger.error("error creating file - bonrix", ex);
            }
        }
    }

    public String getWavFileName() {
        return this.destFileName;
    }
}

